/*
 * Copyright (C) 2014-2019 EXOLIGENT (www.exoligent.com)
 * Author: Maxime Coroyer <maxime.coroyer@exoligent.com>
 */

#ifndef __FW_PCI_H__
#define __FW_PCI_H__

#include <linux/kernel.h>
#include "fw-drv.h"

u8 read_register_u8(void* base_address, u8 offset);
u32 read_register_u32(void* base_address, u8 offset);
void write_register_u8(void* base_address, u8 offset, u8 val);
void write_register_u32(void* base_address, u8 offset, u32 val);

void wait_for_us(u32 delay_us);
u8 wait_for(void* addr, u8 reg, u8 status, u32 timeout_us, u8 trigger_edge);

void eeprom_enable(struct pci_priv_device *dev);
void eeprom_disable(struct pci_priv_device *dev);
void eeprom_do_clock_cycle(struct pci_priv_device *dev);
u8 eeprom_read(struct pci_priv_device *dev, u8 *buffer, u8 start_address, u8 length);
void eeprom_write_data_bit_high(struct pci_priv_device *dev);
void eeprom_write_data_bit_low(struct pci_priv_device *dev);
u8 eeprom_read_data_bit(struct pci_priv_device *dev);
u8 eeprom_read_data_bit_no_clock(struct pci_priv_device *dev);

void init_interrupt(struct pci_priv_device *dev);
int init_dev_infos(struct pci_priv_device *dev);

void fipwatcher_reset(struct pci_priv_device *dev, int fw_num);

#endif 
