/*
 * Copyright (C) 2014-2019 EXOLIGENT (www.exoligent.com)
 * Author: Maxime Coroyer <maxime.coroyer@exoligent.com>
 */

#ifndef __FW_DRV_H__
#define __FW_DRV_H__

#include <linux/cdev.h>
#include <linux/semaphore.h>
#include <linux/ktime.h>

#include "../include/fw-board.h"

#define PCI_MAJOR   0   /* dynamic major by default */
#define PCI_DEVS    8

// PLX UserIO, Serial EEPROM, and
extern int pci_major;
extern int pci_devs;

typedef enum {
    MY_BOARD = 0,
} board_t;

typedef struct _INFO_IO_SPACE
{
    bool      bSpaceMapped;
    uintptr_t nSpaceRange;
    uintptr_t physicalAddress;
    void*     pSpaceBase;
} _INFO_IO_SPACE, *_PINFO_IO_SPACE;

#pragma pack(1) // 1 byte alignment
typedef struct _dev_infos
{
    /* device general info */
    u16             vid;
    u16             did;
    u16             ssvid;
    u16             ssid;
    u32             sn;
    /* physical BAR addresses */
    unsigned long   plx_base;
    unsigned long   plx_size;
    int             nb_fw_mem;
    unsigned long   fw_mem_base;
    unsigned long   fw_mem_size;
    /* irq infos*/
    int             irq_number;
} dev_infos;

typedef struct _dev_interrupts
{
    u8  fw_irq_flag[MAX_FW_CORE];
    u64 fw_irq_counter[MAX_FW_CORE];
} dev_interrupts;
#pragma pack()

struct pci_priv_device {
    _INFO_IO_SPACE      IoSpacePciPlx;
    _INFO_IO_SPACE      IoSpacePciFipWatcher;
    uintptr_t           IoPortPciPlxAddress;
    uintptr_t           IoPortPciPlxSize;

    int                 is_open;    /* 0: free - 1: busy */
    struct list_head    link;       /* Double linked list */
    struct pci_dev      *pci_dev;   /* PCI device */
    struct device       *dev;
    board_t             type;       /* Board type */
    u32                 minor;      /* Minor number */
    struct semaphore    sem;        /* Mutual exclusion */
    struct cdev         cdev;
    int                 int_flag;
    wait_queue_head_t   int_mutex;
    struct spinlock     lock;
    ktime_t             prectime;

    dev_infos           infos;
    dev_interrupts      interrupts;
    u32                 irq_handled_counter;
    u32                 irq_none_handled_counter;
};

extern struct file_operations pcifw_fops;

#endif
