/*
 * Copyright (C) 2014-2019 EXOLIGENT (www.exoligent.com)
 * Author: Maxime Coroyer <maxime.coroyer@exoligent.com>
 */

#ifndef __FW_BOARD_H__
#define __FW_BOARD_H__

//**** PCI CONFIG REGISTERS
#define C_REG_PLX_INTCSR        0x4C
#define C_REG_PLX_CNTRL         0x50
#define C_REG_PLX_GPIOC         0x54
// => Relative to Exoligent
#define C_REG_PLX_RESOURCES     0x58
#define C_REG_PLX_CTRL          0x5C // FipWatcher Control
#define C_REG_PLX_TRIGGER       0x60 // Trigger ID & Delay
#define C_REG_PLX_TEMPERATURE   0x64
#define C_REG_PLX_EPOCH_LSB     0x68
#define C_REG_PLX_EPOCH_MSB     0x6C
#define C_REG_PLX_PMDATASEL     0x70
#define C_REG_PLX_PMDATASCALE   0x74

//**** PCI CONFIG MASKS
// --- on INTCSR
#define C_MK_REG_BIT_IT_LINT1_ENABLE            (1 << 0)
#define C_MK_REG_BIT_IT_LINT1_POLARITY_1        (1 << 1)
#define C_MK_REG_BIT_IT_LINT1_ACTIVE            (1 << 2)
#define C_MK_REG_BIT_IT_LINT2_ENABLE            (1 << 3)
#define C_MK_REG_BIT_IT_LINT2_POLARITY_1        (1 << 4)
#define C_MK_REG_BIT_IT_LINT2_ACTIVE            (1 << 5)
#define C_MK_REG_BIT_IT_ENABLE                  (1 << 6)
#define C_MK_REG_BIT_SOFT_ENABLE                (1 << 7)
#define C_MK_REG_BIT_IT_LINT1_EDGE_ENABLE       (1 << 8)
#define C_MK_REG_BIT_IT_LINT2_EDGE_ENABLE       (1 << 9)
#define C_MK_REG_BIT_IT_LINT1_EDGE_CLEAR        (1 << 10)
#define C_MK_REG_BIT_IT_LINT2_EDGE_CLEAR        (1 << 11)
// --- on CNTRL
#define C_MK_REG_BIT_EEPROM_CLOCK_HIGH          (1 << 24)
#define C_MK_REG_BIT_EEPROM_CS_HIGH             (1 << 25)
#define C_MK_REG_BIT_EEPROM_WRITE_HIGH          (1 << 26)
#define C_MK_REG_BIT_EEPROM_READ_BIT            (1 << 27)
#define C_MK_REG_BIT_READ_EEPROM_PRESENT        (1 << 28)
#define C_MK_REG_BIT_EEPROM_RELOAD_HIGH         (1 << 29)
#define C_MK_REG_BIT_LOCAL_RESET_ON             (1 << 30)
// --- on RESOURCES
#define C_MK_REG_RES_FIPWATCHER_NB              (0x07 << 0)
#define C_MK_REG_RES_HW_TYPE                    (0xC0 << 8)
#define C_MK_REG_RES_PROT_VERSION               (0x0F << 16)
#define C_MK_REG_RES_MAGIC_NUMBER               (0xFF << 24)
// --- on CTRL FW
#define C_MK_REG_CTRL_CONTROL                   (0xFF << 0)
#define C_MK_REG_CTRL_STATUS                    (0xFF << 8)
#define C_MK_REG_CTRL_TIMEOUT_SILENCE           (0xFF << 16)
#define C_MK_REG_CTRL_TRIGGER                   (0xFF << 24)
//     -> Control
#define C_MK_REG_CTRL_SEL                       (0x03 << 0)
#define C_MK_REG_CTRL_FIP_ENABLE                (1 << 2)
#define C_MK_REG_CTRL_CLR_INT                   (1 << 3)
#define C_MK_REG_CTRL_SET_EPOCH                 (1 << 4)
#define C_MK_REG_CTRL_AUTO_RATE                 (1 << 5)
#define C_MK_REG_CTRL_RST_FIP                   (1 << 6)
#define C_MK_REG_CTRL_RST_GLOBAL                (1 << 7)
//     -> Status
#define C_MK_REG_CTRL_STATUS_DATARATE           (0x07 << 0)
#define C_MK_REG_CTRL_STATUS_HW                 (1 << 3)
#define C_MK_REG_CTRL_STATUS_CARD               (1 << 4)
#define C_MK_REG_CTRL_STATUS_OVF                (1 << 5)
#define C_MK_REG_CTRL_STATUS_PID                (0xC0 << 0)
// --- on TRIGGER
#define C_MK_REG_TRIG_DELAY                     (0xFFFF << 0)
#define C_MK_REG_TRIG_ID                        (0xFFFF << 16)
// --- on TEMPERATURE
#define C_MK_REG_TEMP_VALUE                     0xFFFF
#define C_MK_REG_TEMP_R0                        (1 << 21)
#define C_MK_REG_TEMP_R1                        (1 << 22)

//**** BAR ADDR OFFSET
#define MAX_FW_BOARD            8
#define MAX_FW_CORE             4 // Max fipwatcher core inside one board
#define FIPWATCHER_MEM_OFFSET   0x8000

// Area size for one component    
#define FIPWATCHER_MEM_SIZE     0x8000  // 32768 bytes (32kB) => 8192 32-bits word

struct arg_io
{
    void* argIO_In;
    void* argIO_Out;
    int32_t lgIn, lgOut;
    int32_t IoStatus;
};

#pragma pack(1) // 1 byte alignment
typedef struct str_exo_fwdev {
    /* device general info */
    uint16_t        vid;
    uint16_t        did;
    uint16_t        ssvid;
    uint16_t        ssid;
    uint32_t        sn;
    /* physical BAR addresses */
    unsigned long   plx_base;
    unsigned long   plx_size;
    int             nb_fw_mem;
    unsigned long   fw_mem_base;
    unsigned long   fw_mem_size;
    /* irq infos*/
    int             irq_number;
} str_exo_fwdev;

typedef struct str_irq {
    /* flags */
    uint8_t fw_irq_flag;
    /* counters */
    uint64_t fw_irq_counter;
} str_irq;

#pragma pack()

//***************************************************************************************
//                              IOCTLs Definitions
//***************************************************************************************
#define IOCTL_PARAM_SIZE 255 
#define MEMORY_DEVICE 0xFF 

// IOCTL EDA (ExoDevice Access)
// --- Management
#define IOCTL_EDA_GET_DEV_INFO  _IOWR(MEMORY_DEVICE, 0, int)

// Dual FullFIP board
// --- FipWatcher access
#define IOCTL_EDA_FW_RESET      _IOWR(MEMORY_DEVICE, 100, int)
// --- IRQ management
#define IOCTL_EDA_IRQ_WAIT_FOR  _IOWR(MEMORY_DEVICE, 110, int)
#define IOCTL_EDA_IRQ_RESUME    _IOWR(MEMORY_DEVICE, 111, int)

#endif